<html>

<head>
	<meta charset="ISO-8859-1">
	<title>Plan View</title>
	<style>
		body {
			margin: auto;
			width: 70%;
			padding: 10px;
		}

		body {
			size: 100%;
		}

		.center {
			margin: auto;
			width: 80%;
			padding: 10px;
		}

		.column {
			float: left;
			width: 50%;
			padding: 10px;
			height: 300px;

		}

		label {
			font-family: "Google Sans", Arial, sans-serif;
		}

		#empCode {
			font-family: "Google Sans", Arial, sans-serif;
			font-size: 14px;
		}

		.navbar {
			/*font-family: "Google Sans",Arial,sans-serif;*/
			font-family: "Roboto", sans-serif;
		}

		input[type="text"] {
			font-family: "Google Sans", Arial, sans-serif !important;
			font-size: 16px;
			width: 150px;
			border: 1px solid black;

		}

		button {
			font-family: "Google Sans", Arial, sans-serif !important;
			font-size: 14px;
			margin-top: 10px;
		}

		input[type="date"],
		select {
			font-family: "Google Sans", Arial, sans-serif !important;
			border: 1px solid #c4c4c4;
			border-radius: 5px;
			background-color: #fff;
			padding: 3px 5px;
			box-shadow: inset 0 3px 6px rgba(0, 0, 0, 0.1);

		}

		input[type="submit"] {
			font-size: 16px;
		}

		input[type="button"] {
			font-family: "Google Sans", Arial, sans-serif !important;
		}

		#tableView {
			margin-top: 20px;
		}

		table {
			border-collapse: collapse;
			/* margin: 25px 0;*/
			font-size: 0.9em;
			font-family: "Google Sans", Arial, sans-serif !important;
			min-width: 400px;
			box-shadow: 0 0 20px rgba(0, 0, 0, 0.15);
		}

		table thead tr {

			text-align: left;
		}

		table th,
		table td {
			padding: 12px 15px;
		}

		table tbody tr {
			border-bottom: 1px solid #dddddd;
		}

		table tbody tr:nth-of-type(even) {
			background-color: #f3f3f3;
		}

		table tbody tr.active-row {
			font-weight: bold;
			color: #009879;
		}

		.head {
			font-family: "Google Sans", Arial, sans-serif !important;
			background-color: #009879;
			color: #ffffff;
		}

		table tbody tr:last-of-type {
			border-bottom: 2px solid #009879;
		}

		.headmenu {
			width: 100%;
			height: 100px;
			overflow-x: scroll;
			overflow-y: hidden;
		}

		.container {
			width: 2500px;
		}

		.grid-container {
			display: table;
			width: auto;
			border-spacing: 5px;

		}

		.div-table-row {
			display: table-row;
			width: auto;
			clear: both;
		}

		.div-table-col {
			float: left;
			display: table-column;
			width: 400px;

		}

		/*For Loading Icon*/
		#loading-overlay {
			position: fixed;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			background-color: rgba(0, 0, 0, 0.5);
			/* Semi-transparent background */
			z-index: 9999;
			/* Ensure the loading overlay appears on top of other elements */
		}

		#loading-icon {
			position: absolute;
			top: 50%;
			left: 50%;
			transform: translate(-50%, -50%);
			width: 150px;
			/* Adjust the width of the spinner */
			height: 150px;
			/* Adjust the height of the spinner */
			background-image: url(Spinner.svg);
			/* Specify the path to the spinner SVG file */
			background-repeat: no-repeat;
			background-position: center;
		}
	</style>
</head>

<body>

	<div id="loading-overlay">
		<div id="loading-icon"></div>
	</div>
	<div>
		<h1 class="center" id="title" style="text-align:center">Plan View</h1>
		<!--<select name="empCode" id="empCode" onChange="" style="width:150px;">
			<option>Select Employee</option>
		</select>-->
		<br>
	</div>
	<div>
		<div class="tab">
			<button id="viewPlanButton" class="tablinks" onclick="openPage(event, 'plan')">VIEW PLAN</button>
			<button class="tablinks" onclick="openPage(event, 'feedback')">VIVE FEEDBACK</button>

		</div>

		<!-- Tab content -->
		<div id="plan" class="content" style="display:block; border:3px solid white;">
			<h3>Today's Plan</h3>
			<table width=100% id="planTable">
				<thead>
					<tr class="head">
						<td>Person</td>
						<td>Date</td>
						<td>RequestID</td>
						<td>Details DESC</td>
						<!-- <td>Action DTL</td> -->
						<td>STD Time</td>
					</tr>
				</thead>
				<tbody>
				</tbody>
			</table>
		</div>

		<div id="feedback" class="content" style="display:none;border:3px solid white;">
			<h3>Feedback</h3>
			<table width=100% id="feedbackTable">
				<thead>
					<tr class="head">
						<td>Person</td>
						<td>RequestID</td>
						<td>Feedback Date</td>
						<td>Details DESC</td>
						<td>Feedback</td>
						<td>STD Time</td>
						<td>Spend Time</td>
					</tr>
				</thead>
				<tbody>
				</tbody>
			</table>
		</div>
	</div>

</body>
<script type="text/javascript">
	var loadingOverlay = document.getElementById('loading-overlay');
	loadingOverlay.style.display='none';
	window.addEventListener('load', function () {
		var viewPlanButton = document.getElementById('viewPlanButton');

		viewPlanButton.click();
	});

	function openPage(evt, tabname) {
		loadingOverlay.style.display='block';
		if (tabname == 'plan') {
			var table = document.getElementById("plantable");

			document.getElementById(tabname).style.display = "block";
			document.getElementById('feedback').style.display = "none";
			document.getElementById('title').innerHTML = "Plan View";

			var xhr = new XMLHttpRequest();
			var action = tabname;
			xhr.open('GET', '/ibase/planview?action=' + encodeURIComponent(action), true);
			xhr.onreadystatechange = function () {
				if (xhr.readyState === 4 && xhr.status === 200) {
					var planList = JSON.parse(xhr.responseText);

					console.log(JSON.stringify(planList));
					var tableBody = document.querySelector('#planTable tbody');
					tableBody.innerHTML = '';
					if (planList.length === 0) {
						// Display a message indicating that the list is empty
						var emptyRow = document.createElement('tr');
						emptyRow.innerHTML = '<td colspan="6">No plans available</td>';
						tableBody.appendChild(emptyRow);
					} else {
						// Iterate over the planList and generate table rows dynamically
						planList.forEach(function (plan) {

							var row = document.createElement('tr');
							row.innerHTML = `
          									<td>${plan.name}</td>
          									<td>${plan.date}</td>
          									<td>${plan.requestid}</td>
          									<td>${plan.description}</td>
          									<td>${plan.actiondtl}</td>
          									<td>${plan.time}</td>
        									`;
							tableBody.appendChild(row);
						});
					}
					loadingOverlay.style.display = 'none';
				}
			};
			xhr.send();




		}
		else if (tabname == 'feedback') {
			document.getElementById(tabname).style.display = "block";
			document.getElementById('plan').style.display = "none";
			document.getElementById('title').innerHTML = "Feedback View";
			var xhr = new XMLHttpRequest();
			var action = tabname;
			xhr.open('GET', '/ibase/planview?action=' + encodeURIComponent(action), true);
			xhr.onreadystatechange = function () {
				if (xhr.readyState === 4 && xhr.status === 200) {
					var feedbackList = JSON.parse(xhr.responseText);

					console.log(JSON.stringify(feedbackList));
					var tableBody = document.querySelector('#feedbackTable tbody');
					tableBody.innerHTML = '';
					if (feedbackList.length === 0) {
						var emptyRow = document.createElement('tr');
						emptyRow.innerHTML = '<td colspan="6">No plans available</td>';
						tableBody.appendChild(emptyRow);
					}
					else {
						feedbackList.forEach(function (feedback) {
							var row = document.createElement('tr');
							row.innerHTML = `
          									<td>${feedback.name}</td>
          									<td>${feedback.date}</td>
          									<td>${feedback.requestid}</td>
          									<td>${feedback.description}</td>
          									<td>${feedback.actiondtl}</td>
          									<td>${feedback.time}</td>
        									`;
							tableBody.appendChild(row);
						});
					}
				}
			};
			xhr.send();
		}
		loadingOverlay.style.display='none';

	}


</script>

</html>